//This file is part of LiveCoding1. Copyright (C) 2006  Nicholas M.Collins distributed under the terms of the GNU General Public License full notice in file LiveCoding1.help

//2D slider in a window with associated control busses, updated at 15Hz
//no free on close in case still have busses in use by running processes

LC2DSliderWindow {	
	var w, slid, <x, <y, <cx, <cy, <xind, <yind;
	
	*new {arg name;
		^super.new.initLC2DSliderWindow(name);
	}
	
	initLC2DSliderWindow {arg name;
		
		cx=Bus.control(Server.default, 1);
		cy=Bus.control(Server.default, 1);	
	
		xind=cx.index;
		yind=cy.index;
		
		w=SCWindow(name ? "LC2DSlid",Rect(700,400,220,220));
		
		slid=SC2DSlider(w,Rect(10,10,200,200));
		
		x=0.0; y=0.0;
		
		slid.action_({
		x=slid.x; y=slid.y;
		
		cx.set(x);
		cy.set(y);
		});
		
		w.front;
	}
	
	set {arg xval,yval; 
		
		cx.set(xval);
		cy.set(yval);
		
		slid.x_(xval);
		slid.y_(yval);
	}
	
	close {
		w.close;
		cx.free;
		cy.free;
	}
	
	//only linear- need exponential mappings too? LinExp etc
	
	//LinLin and LinExp could help
	
	xkr { arg start=0.0,end=1.0, warp='linear';
	
	^if(warp=='linear',{LinLin.kr(In.kr(xind,1),0.0,1.0,start,end)},
	{LinExp.kr(In.kr(xind,1),0.0,1.0,start,end)}
	);
	
	//start+((end-start)*In.kr(xind,1));
	}

	ykr { arg start=0.0,end=1.0, warp='linear';
	
	^if(warp=='linear',{LinLin.kr(In.kr(yind,1),0.0,1.0,start,end)},
	{LinExp.kr(In.kr(yind,1),0.0,1.0,start,end)}
	);
	
	//start+((end-start)*In.kr(yind,1));
	}
}